/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.core;

import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsTest
extends AbstractMatcherTest {
    @Override
    protected Matcher<?> createMatcher() {
        return Is.is((Object)"something");
    }

    public void testJustMatchesTheSameWayTheUnderylingMatcherDoes() {
        IsTest.assertMatches("should match", Is.is((Matcher)IsEqual.equalTo((Object)true)), true);
        IsTest.assertMatches("should match", Is.is((Matcher)IsEqual.equalTo((Object)false)), false);
        IsTest.assertDoesNotMatch("should not match", Is.is((Matcher)IsEqual.equalTo((Object)true)), false);
        IsTest.assertDoesNotMatch("should not match", Is.is((Matcher)IsEqual.equalTo((Object)false)), true);
    }

    public void testGeneratesIsPrefixInDescription() {
        IsTest.assertDescription("is <true>", Is.is((Matcher)IsEqual.equalTo((Object)true)));
    }

    public void testProvidesConvenientShortcutForIsEqualTo() {
        IsTest.assertMatches("should match", Is.is((Object)"A"), "A");
        IsTest.assertMatches("should match", Is.is((Object)"B"), "B");
        IsTest.assertDoesNotMatch("should not match", Is.is((Object)"A"), "B");
        IsTest.assertDoesNotMatch("should not match", Is.is((Object)"B"), "A");
        IsTest.assertDescription("is \"A\"", Is.is((Object)"A"));
    }

    public void testProvidesConvenientShortcutForIsInstanceOf() {
        IsTest.assertTrue((String)"should match", (boolean)Is.is(String.class).matches((Object)"A"));
        IsTest.assertFalse((String)"should not match", (boolean)Is.is(Integer.class).matches(new Object()));
        IsTest.assertFalse((String)"should not match", (boolean)Is.is(Integer.class).matches(null));
    }
}

